﻿;Copyright 2007-2015 John T. Haller of PortableApps.com
;Website: http://PortableApps.com/

;This software is OSI Certified Open Source Software.
;OSI Certified is a certification mark of the Open Source Initiative.

;This program is free software; you can redistribute it and/or
;modify it under the terms of the GNU General Public License
;as published by the Free Software Foundation; either version 2
;of the License, or (at your option) any later version.

;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.

;You should have received a copy of the GNU General Public License
;along with this program; if not, write to the Free Software
;Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

;EXCEPTION: The PortableApps.com Installer can be used with open source
;applications licensed under OSI-approved licenses as well as freeware provided
;it is unmodified and it adheres to the current PortableApps.com Format Specification
;as published at PortableApps.com/development. It may also be used with commercial
;software by contacting PortableApps.com.

!define PORTABLEAPPSINSTALLERVERSION "3.0.19.0"
!define PORTABLEAPPS.COMFORMATVERSION "3.0.19"

!if ${__FILE__} == "PortableApps.comInstallerPlugin.nsi"
	!include PortableApps.comInstallerPluginConfig.nsh
	!define PLUGININSTALLER
!else
	!include PortableApps.comInstallerConfig.nsh
!endif

# MANiFEST
!define RequestLevel USER
!define ResHacker    `${NSISDIR}\Contrib\Manifests\ResHacker.exe`
!define ManifDir     `${NSISDIR}\Contrib\Manifests`
!define Manifest     `NSIS_2.46_Win8`
!packhdr             `$%TEMP%\exehead.tmp` `"${Reshacker}" -addoverwrite "%TEMP%\exehead.tmp", "%TEMP%\exehead.tmp", "${ManifDir}\${Manifest}_${RequestLevel}.manifest", 24,1,1033`

# TESTiNG
;!define NOCOMPRESSION

# DEFiNE
!define BUILD      8.0.0.4
!define APP        ExamDiff
!define APP64      ExamDiff64
!define FULLNAME   `ExamDiff Pro`
!define APPDIR     `$INSTDIR\App\${APP}`
!define APPDIR64   `$INSTDIR\App\${APP64}`
!define APPNAME    `${APP}Portable`
!define APPINFO    `$INSTDIR\App\AppInfo`
!define LAUNCHER   `${APPINFO}\Launcher`
!define DATA       `$INSTDIR\Data`
!define DEFDATA    `$INSTDIR\App\DefaultData`
!define DEFSET     `${DEFDATA}\settings`
!define SET        `$INSTDIR\Data\settings`
!define OTHER      `$INSTDIR\Other`
!define BRANDING   `PrestoSoft LLC`
!define EXE        `$INSTDIR\${APPNAME}.exe`
!define LEGAL      `Copyright © 1997-2015 PrestoSoft LLC`
!define INI        `$INSTDIR\Backup_log.ini`
!define INS        `${APPINFO}\installer.ini`

# VARiABLE
var ADDITIONALPARAMETERS
var RUNLOCALLY
var USBDevice
var ShellExtension

# SECTiON
!define MAINSECTIONIDX 0
!ifdef MAINSECTIONTITLE
	!define SECTION_ON ${SF_SELECTED}
	!include Sections.nsh
	!define OPTIONALSECTION1 1
	!define OPTIONALSECTION2 2
!endif

# SECTiON
var SECTION1
var SECTION2
;===
!define DEFAULTSIZE                 0
;===
!define OPTIONALSECTION1SIZE        15572
!define OPTIONALSECTION1TITLE       `ExamDiff Pro x86 (32-bit)`
!define OPTIONALSECTION1DESCRIPTION `compatible with Windows x32 or Windows x64`
;===
!define OPTIONALSECTION2SIZE        17549
!define OPTIONALSECTION2TITLE       `ExamDiff Pro x64 (64-bit)`
!define OPTIONALSECTION2DESCRIPTION `compatible with Windows x64 only`

# SPECiFiCATIONS
Name "${PORTABLEAPPNAME}" "${PORTABLEAPPNAMEDOUBLEDAMPERSANDS}"
OutFile "..\..\..\${FILENAME}.paf.exe"
!ifdef COMMONFILESPLUGIN
	InstallDir "\CommonFiles\${APPID}"
!else
	InstallDir "\${APPID}"
!endif
Caption                          `${FULLNAME}`
VIProductVersion                 `${BUILD}`
VIAddVersionKey ProductName      `${FULLNAME}`
VIAddVersionKey Comments         http://portablewares.blogspot.com/
VIAddVersionKey CompanyName      `${BRANDING}`
VIAddVersionKey LegalCopyright   `${LEGAL}`
VIAddVersionKey FileDescription  `${FULLNAME}`
VIAddVersionKey FileVersion      `${BUILD}`
VIAddVersionKey ProductVersion   Portable
VIAddVersionKey InternalName     `${PORTABLEAPPNAME}`
;VIAddVersionKey LegalTrademarks 
VIAddVersionKey OriginalFilename `${FILENAME}.paf.exe`
VIAddVersionKey PortableApps.comInstallerVersion "${PORTABLEAPPSINSTALLERVERSION}"
VIAddVersionKey PortableApps.comFormatVersion "${PORTABLEAPPS.COMFORMATVERSION}"
VIAddVersionKey PortableApps.comAppID "${APPID}"
!ifdef DownloadURL ;advertise the needed bits to the PA.c Updater
	VIAddVersionKey PortableApps.comDownloadURL "${DownloadURL}"
	VIAddVersionKey PortableApps.comDownloadKnockURL "${DownloadKnockURL}"
	VIAddVersionKey PortableApps.comDownloadName "${DownloadName}"
	VIAddVersionKey PortableApps.comDownloadFileName "${DownloadFileName}"
	VIAddVersionKey PortableApps.comDownloadMD5 "${DownloadMD5}"
!endif

!ifdef NOCOMPRESSION
	SetCompress off
!else
	SetCompress Auto
	SetCompressor /SOLID lzma
	SetCompressorDictSize 32
	SetDatablockOptimize On
!endif

CRCCheck on
AutoCloseWindow True
RequestExecutionLevel user
AllowRootDirInstall true
;=== Include
!include MUI2.nsh
!include FileFunc.nsh
!include LogicLib.nsh
!ifdef PRESERVEFILE1
	!include PortableApps.comInstallerMoveFiles.nsh
!endif
!ifdef COPYLOCALFILES
	!include Registry.nsh
!endif
!include TextFunc.nsh
!include WordFunc.nsh
!include PortableApps.comInstallerDriveFreeSpaceCustom.nsh
!include PortableApps.comInstallerDumpLogToFile.nsh
!include PortableApps.comInstallerTBProgress.nsh

;=== CUSTOM iNCLUDES
!include WinVer.nsh
;!include ReplaceInFileWithTextReplace.nsh
;!include LineWrite.nsh

;=== Program Icon
Icon "PortableApps.comInstaller.ico"
!define MUI_ICON "PortableApps.comInstaller.ico"
!define MUI_UNICON "PortableApps.comInstaller.ico"
!define MUI_HEADERIMAGE
!define MUI_HEADERIMAGE_BITMAP "PortableApps.comInstallerHeader.bmp"
!define MUI_HEADERIMAGE_BITMAP_RTL "PortableApps.comInstallerHeaderRTL.bmp"
!define MUI_HEADERIMAGE_RIGHT

;=== Icon & Stye ===
BrandingText "${LEGAL}"

;=== Pages
!ifdef COPYLOCALFILES
	!define MUI_CUSTOMFUNCTION_ABORT CustomAbortFunction
!endif
!define MUI_LANGDLL_WINDOWTITLE "${PORTABLEAPPNAME}"
!define MUI_LANGDLL_INFO "Please select a language:"
!define MUI_WELCOMEFINISHPAGE_BITMAP "PortableApps.comInstaller.bmp"
!ifdef PLUGINNAME
	!define MUI_WELCOMEPAGE_TITLE "${PORTABLEAPPNAMEDOUBLEDAMPERSANDS}"
!else
	!define MUI_WELCOMEPAGE_TITLE "${PORTABLEAPPNAMEDOUBLEDAMPERSANDS}"
!endif
!define MUI_WELCOMEPAGE_TEXT "$(welcome)"
!define MUI_PAGE_CUSTOMFUNCTION_PRE PreWelcome
!define MUI_COMPONENTSPAGE_SMALLDESC
!insertmacro MUI_PAGE_WELCOME
!ifdef LICENSEAGREEMENT
	;!define MUI_LICENSEPAGE_CHECKBOX
	!define MUI_PAGE_CUSTOMFUNCTION_PRE PreLicense
	!define MUI_PAGE_CUSTOMFUNCTION_SHOW ShowLicense
	!define MUI_PAGE_CUSTOMFUNCTION_LEAVE LeaveLicense
	!insertmacro MUI_PAGE_LICENSE "..\..\App\AppInfo\${LICENSEAGREEMENT}"
!endif
!ifdef MAINSECTIONTITLE
	!define MUI_PAGE_CUSTOMFUNCTION_PRE PreComponents
	!insertmacro MUI_PAGE_COMPONENTS
!endif
!define MUI_DIRECTORYPAGE_VERIFYONLEAVE
!define MUI_PAGE_CUSTOMFUNCTION_PRE PreDirectory
!define MUI_PAGE_CUSTOMFUNCTION_LEAVE LeaveDirectory
!insertmacro MUI_PAGE_DIRECTORY
!define MUI_PAGE_CUSTOMFUNCTION_SHOW ShowInstFiles
!insertmacro MUI_PAGE_INSTFILES
!define MUI_FINISHPAGE_TEXT "$(finish)"
!define MUI_PAGE_CUSTOMFUNCTION_PRE PreFinish
!define MUI_FINISHPAGE_TITLE_3LINES
;!define MUI_FINISHPAGE_CANCEL_ENABLED ;Disabled due to bug in MUI2
;!ifndef PLUGINNAME
;	!define MUI_FINISHPAGE_RUN_NOTCHECKED
;	!define MUI_FINISHPAGE_RUN "$INSTDIR\${FINISHPAGERUN}"
;!endif
!insertmacro MUI_PAGE_FINISH

;=== Languages
!ifndef INSTALLERMULTILINGUAL
	!insertmacro MUI_LANGUAGE "${INSTALLERLANGUAGE}"
	!include PortableApps.comInstallerLanguages\${INSTALLERLANGUAGE}.nsh
!else
	!tempfile LangAutoDetectFile
	!macro IncludeLang _LANG_NAME
		!ifdef USES_${_LANG_NAME}
			!insertmacro MUI_LANGUAGE "${_LANG_NAME}"
			!include PortableApps.comInstallerLanguages\${_LANG_NAME}.nsh
			!appendfile "${LangAutoDetectFile}" "${Case} ${LANG_${_LANG_NAME}}$\n"
		!endif
	!macroend
	!define IncludeLang "!insertmacro IncludeLang"
	${IncludeLang} ENGLISH
	!insertmacro MUI_RESERVEFILE_LANGDLL
!endif

;=== Macros
!macro _ReDef _NAME _VAL
	!ifdef ${_NAME}
	!undef ${_NAME}
	!endif
	!define ${_NAME} `${_VAL}`
!macroend
!define ReDef "!insertmacro _ReDef "
Function GetAfterChar
	!macro _GetAfterChar _STR _CHAR _RET
		Push `${_STR}`
		Push `${_CHAR}`
		Call GetAfterChar
		Pop `${_RET}`
	!macroend
	!define GetAfterChar "!insertmacro _GetAfterChar"
	Exch $0
	Exch
	Exch $1
	Push $2
	Push $3
	StrCpy $2 0
	IntOp $2 $2 - 1
	StrCpy $3 $1 1 $2
	StrCmp $3 "" 0 +3
	StrCpy $0 ""
	Goto +5
	StrCmp $3 $0 +2
	Goto -6
	IntOp $2 $2 + 1
	StrCpy $0 $1 "" $2
	Pop $3
	Pop $2
	Pop $1
	Exch $0
FunctionEnd
Function RelGotoPage
	IntCmp $R9 0 0 Move Move
	StrCmp $R9 "X" 0 Move
	StrCpy $R9 "120"
	Move:
	SendMessage $HWNDPARENT "0x408" "$R9" ""
FunctionEnd
!define CABW         CabinetWClass
Function Close
	!macro _Close _CLASS _TITLE
		Push `${_TITLE}`
		Push `${_CLASS}`
		Call Close
	!macroend
	!define Close `!insertmacro _Close`
	Exch $R2
	Exch
	Exch $R1
	Push $R0
	Search:
		FindWindow $R0 `$R2` `$R1`
		IntCmp $R0 0 END 0 0
		IsWindow $R0 0 END
		System::Call `user32::PostMessage(i,i,i,i) i($R0,0x0010,0,0)`
		Sleep 100
		Goto Search
	END:
	Pop $R0
	Pop $R1
	Pop $R2
FunctionEnd
!macro !insertmacro1-10 _m
!insertmacro ${_m} 1
!insertmacro ${_m} 2
!insertmacro ${_m} 3
!insertmacro ${_m} 4
!insertmacro ${_m} 5
!insertmacro ${_m} 6
!insertmacro ${_m} 7
!insertmacro ${_m} 8
!insertmacro ${_m} 9
!insertmacro ${_m} 10
!macroend
!define !insertmacro1-10 "!insertmacro !insertmacro1-10"

;=== Variables
Var FOUNDPORTABLEAPPSPATH
!ifdef MAINSECTIONTITLE
;	Var OPTIONAL1DONE
!endif
Var AUTOMATEDINSTALL
Var AUTOCLOSE
Var SILENTLANGUAGEMODE
Var HIDEINSTALLER
Var MINIMIZEINSTALLER
!ifdef LICENSEAGREEMENT
	Var EULAVERSIONMATCH
!endif
!ifdef COPYLOCALFILES
	Var CopyLocalFilesFrom
	Var CopyLocalFilesTo
	Var MISSINGFILEORPATH
!endif
!ifdef DOWNLOADURL
	Var MD5MISMATCH
	Var DOWNLOADRESULT
	Var DOWNLOADEDFILE
	Var DOWNLOADALREADYEXISTED
	Var SECONDDOWNLOADATTEMPT
	Var DownloadURLActual
!endif
Var INTERNALEULAVERSION
Var InstallingStatusString
Var bolAppUpgrade
Var bolLogFile
Var PAcLocaleID
Var strLastDirectory
Var strTimeStore

;=== Custom Code
!ifdef USESCUSTOMCODE
	!if ${__FILE__} == "PortableApps.comInstallerPlugin.nsi"
		!include PortableApps.comInstallerPluginCustom.nsh
	!else
		!include PortableApps.comInstallerCustom.nsh
	!endif
!endif

!ifdef INSTALLERMULTILINGUAL
	!macro CaseLang _LANG_NAME _LANG_ID
		!ifdef USES_${_LANG_NAME}
			${Case} ${_LANG_ID}
		!endif
	!macroend
	!define CaseLang "!insertmacro CaseLang"
!endif

Function .onInit
	SectionSetSize 1 ${OPTIONALSECTION1SIZE}
	SectionSetSize 2 ${OPTIONALSECTION2SIZE}

	SetSilent normal

	!ifdef DownloadURL
	StrCpy $R0 $EXEFILE "" -15
	${If} $R0 != "_online.paf.exe"
	${AndIf} $R0 != "line.paf[1].exe" ;Handle IE's renaming of files when run directly from a download
	${AndIf} $R0 != "line.paf[2].exe"
	${AndIf} $R0 != "line.paf[3].exe"
	${AndIf} $R0 != "line.paf[4].exe"
	${AndIf} $R0 != "line.paf[5].exe"
	${AndIf} $R0 != "line.paf[6].exe"
	${AndIf} $R0 != "line.paf[7].exe"
	${AndIf} $R0 != "line.paf[8].exe"
	${AndIf} $R0 != "line.paf[9].exe"
		MessageBox MB_OK|MB_ICONSTOP `PortableApps.com Installers that download files must end with "_online.paf.exe".  This is to ensure that users always know that an installer downloads files before it is run.  Please rename the file to end in _online.paf.exe before running.`
		Abort
	${EndIf}
	!endif

	InitPluginsDir

	!ifdef INSTALLERMULTILINGUAL
		ReadEnvStr $PAcLocaleID "PortableApps.comLocaleID"
		${Switch} $PAcLocaleID
			; Use the Case statements formed earlier.
			!include "${LangAutoDetectFile}"
			!delfile "${LangAutoDetectFile}"
			!undef LangAutoDetectFile
				StrCpy $LANGUAGE $PAcLocaleID
				${Break}
			${Default}
				${GetOptions} $CMDLINE "/DESTINATION=" $0
				${IfNot} ${Errors}
				${AndIf} ${FileExists} `$0\PortableApps.com\PortableAppsPlatform.exe`
					;Automated platform install but doesn't support the exact language
					
					;Language Fallbacks, if none, then English
					${If} $PAcLocaleID == 3082 ;SpanishInternational
					${AndIf} ${USES_SPANISH} == "true"
						StrCpy $LANGUAGE 1034 ;Spanish
					${Else}
						${If} $PAcLocaleID == 1034 ;Spanish
						${AndIf} ${USES_SPANISHINTERNATIONAL} == "true"
							StrCpy $LANGUAGE 3082 ;SpanishInternational
						${Else}
							${If} $PAcLocaleID == 1046 ;PortugueseBR
							${AndIf} ${USES_PORTUGUESE} == "true"
								StrCpy $LANGUAGE 2070 ;Portuguese
							${Else}
								${If} $PAcLocaleID == 2070 ;Portuguese
								${AndIf} ${USES_PORTUGUESEBR} == "true"
									StrCpy $LANGUAGE 1046 ;PortugueseBR
								${Else}
									StrCpy $LANGUAGE 1033 ;English as last fallback
								${EndIf}
							${EndIf}
						${EndIf}
					${EndIf}
				${Else}
					!insertmacro MUI_LANGDLL_DISPLAY
				${EndIf}
		${EndSwitch}
	!endif

	;=== Check for logging mode
	${GetOptions} $CMDLINE "/LOG=" $0
	
	${IfNot} ${Errors}
	${AndIf} $0 == "true"
		StrCpy $bolLogFile true
	${Else}
		ClearErrors
	${EndIf}
	
	;=== Check for a specified installation directory
	${GetOptions} $CMDLINE "/DESTINATION=" $0

	${IfNot} ${Errors}
		!ifdef COMMONFILESPLUGIN
			StrCpy $INSTDIR "$0CommonFiles\${APPID}"
		!else
			${GetOptions} $CMDLINE "/COPYNUMBER=" $1
			${IfNot} ${Errors}
				StrCpy $INSTDIR "$0${APPID}_Copy_$1"
			${Else}
				StrCpy $INSTDIR "$0${APPID}"
			${EndIf}
		!endif

		!ifdef LICENSEAGREEMENT
			!ifndef EULAVERSION
				StrCpy $INTERNALEULAVERSION "1"
			!else
				StrCpy $INTERNALEULAVERSION ${EULAVERSION}
			!endif
			${If} ${FileExists} "$INSTDIR\Data\PortableApps.comInstaller\license.ini"
				ReadINIStr $0 "$INSTDIR\Data\PortableApps.comInstaller\license.ini" "PortableApps.comInstaller" "EULAVersion"
				ClearErrors
				${If} $0 == $INTERNALEULAVERSION
					StrCpy $EULAVERSIONMATCH "true"
				${EndIf}
			${EndIf}
		!endif

		;=== Check for PortableApps.com Platform
		${GetParent} $INSTDIR $0
		!ifdef COMMONFILESPLUGIN
			${GetParent} $0 $0
		!endif

		;=== Check that it exists at the right location
		DetailPrint '$(checkforplatform)'

		${If} ${FileExists} `$0\PortableApps.com\PortableAppsPlatform.exe`
			;=== Check that it's the real deal
			MoreInfo::GetProductName `$0\PortableApps.com\PortableAppsPlatform.exe`
			Pop $1
			${If} $1 == "PortableApps.com Platform"
				MoreInfo::GetCompanyName `$0\PortableApps.com\PortableAppsPlatform.exe`
				Pop $1
				${If} $1 == "PortableApps.com"
					;=== Check that it's running
					FindProcDLL::FindProc "PortableAppsPlatform.exe"
					${If} $R0 == 1
						;=== Do a partially automated install
						StrCpy $AUTOMATEDINSTALL "true"

						ClearErrors
						${GetOptions} $CMDLINE "/AUTOCLOSE=" $R0
						${IfNot} ${Errors}
						${AndIf} $R0 == "true"
							StrCpy $AUTOCLOSE "true"
						${EndIf}

						ClearErrors
						${GetOptions} $CMDLINE "/HIDEINSTALLER=" $R0
						${IfNot} ${Errors}
						${AndIf} $R0 == "true"
							StrCpy $HIDEINSTALLER "true"
						${EndIf}

						ClearErrors
						${GetOptions} $CMDLINE "/MINIMIZEINSTALLER=" $R0
						${IfNot} ${Errors}
						${AndIf} $R0 == "true"
							StrCpy $MINIMIZEINSTALLER "true"
						${EndIf}

						ClearErrors
						${GetOptions} $CMDLINE "/SILENT=" $R0
						${IfNot} ${Errors}
						${AndIf} $R0 == "true"
							;Duplicate of the size calculation code, to be functionalized later
							SectionGetSize ${MAINSECTIONIDX} $1 ;=== Space Required for App
							
							!ifdef MAINSECTIONTITLE
								SectionGetFlags ${OPTIONALSECTIONIDX} $9
								IntOp $9 $9 & ${SF_SELECTED}
								${If} $9 >= ${SF_SELECTED}
									SectionGetSize ${OPTIONALSECTIONIDX} $2 ;=== Space Required for App
									IntOp $1 $1 + $2
								${EndIf}
							!endif
							${GetRoot} $INSTDIR $2
							;${DriveSpace} `$2\` "/D=F /S=M" $3 ;=== Space Free on Device
							${DriveFreeSpaceCustom} "$2\" $3
							
							;Convert app size to MB from KB
							IntOp $1 $1 / 1024
							
							${If} $1 == 0
							;If less than 1MB, round to 1MB
								StrCpy $1 1
							${EndIf}
							
							${If} $3 <= $1
								IntOp $1 $1 * 1024
								IntOp $3 $3 * 1024
								!ifndef PLUGININSTALLER ;=== If not a plugin installer, add the current install size to free space
									${If} ${FileExists} $INSTDIR
										${GetSize} `$INSTDIR` "/M=*.* /S=0K /G=0" $4 $5 $6 ;=== Current installation size
										IntOp $3 $3 + $4 ;=== Space Free + Current Root Install Size
										${GetSize} `$INSTDIR\App` "/M=*.* /S=0K /G=1" $4 $5 $6 ;=== Current installation size
										IntOp $3 $3 + $4 ;=== Space Free + Current App Install Size
										${GetSize} `$INSTDIR\Other` "/M=*.* /S=0K /G=1" $4 $5 $6 ;=== Current installation size
										IntOp $3 $3 + $4 ;=== Space Free + Current Other Install Size

										${If} `${ADDONSDIRECTORYPRESERVE}` != "NONE"
										${AndIf} ${FileExists} `$INSTDIR\${ADDONSDIRECTORYPRESERVE}`
												${GetSize} `$INSTDIR\${ADDONSDIRECTORYPRESERVE}` "/M=*.* /S=0K /G=1" $4 $5 $6 ;=== Size of Data directory
												IntOp $3 $3 - $4 ;=== Remove the plugins directory from the free space calculation
										${EndIf}
									${EndIf}
								!else
									!ifdef COMMONFILESPLUGIN ;Duplicate code for now, to do above for CommonFiles as well
										${If} ${FileExists} $INSTDIR
											${GetSize} `$INSTDIR` "/M=*.* /S=0K /G=1" $4 $5 $6 ;=== Current installation size
											IntOp $3 $3 + $4 ;=== Space Free + Current Install Size
										${EndIf}
									!endif
								!endif
								${If} $3 <= $1
									MessageBox MB_OK|MB_ICONEXCLAMATION "$(notenoughspace)"
									Abort
								${EndIf}
							${EndIf}

							!ifdef LICENSEAGREEMENT
								${If} $EULAVERSIONMATCH == "true"
									SetSilent silent
								${EndIf}
							!else
								SetSilent silent
							!endif
						${EndIf}

						ClearErrors
						${GetOptions} $CMDLINE "/SILENTLANGUAGEMODE=" $R0
						${IfNot} ${Errors}
							${If} $R0 == "auto"
							${OrIf} $R0 == "never"
							${OrIf} $R0 == "always"
								StrCpy $SILENTLANGUAGEMODE $R0
							${Else}
								StrCpy $SILENTLANGUAGEMODE "auto"
							${EndIf}
						${Else}
							StrCpy $SILENTLANGUAGEMODE "auto"
						${EndIf}

					${EndIf}
				${EndIf}
			${EndIf}
		${EndIf}
	${Else}
		ClearErrors
		;=== Check legacy location
		${GetOptions} $CMDLINE "-o" $R0
		${IfNot} ${Errors}
			!ifdef COMMONFILESPLUGIN
				StrCpy $INSTDIR "$R0CommonFiles\${APPID}"
			!else
				StrCpy $INSTDIR "$R0${APPID}"
			!endif
		${Else}
			;=== No installation directory found
			ClearErrors
			${If} ${FileExists}	"$PROFILE\PortableApps\*.*"
				StrCpy $FOUNDPORTABLEAPPSPATH "$Profile\PortableApps"
			${Else}
				${GetDrives} "HDD+FDD" GetDrivesCallBack
			${EndIf}
			${If} $FOUNDPORTABLEAPPSPATH != ""
				!ifdef COMMONFILESPLUGIN
					StrCpy $INSTDIR "$FOUNDPORTABLEAPPSPATH\CommonFiles\${APPID}"
				!else
					StrCpy $INSTDIR "$FOUNDPORTABLEAPPSPATH\${APPID}"
				!endif
			${Else}
				;If within Program Files, TEMP or IE Cache, no default install path
				${WordFind} "$EXEDIR\" "$PROGRAMFILES\" "*" $R0
				${WordFind} "$EXEDIR\" "$PROGRAMFILES64\" "*" $R1
				${WordFind} "$EXEDIR\" "$INTERNET_CACHE\" "*" $R2
				${WordFind} "$EXEDIR\" "$TEMP\" "*" $R3
					
				${If} $R0 > 0
				${OrIf} $R1 > 0
				${OrIf} $R2 > 0
				${OrIf} $R3 > 0
					StrCpy $INSTDIR ""
				${Else}
					!ifdef COMMONFILESPLUGIN
						StrCpy $INSTDIR "$EXEDIR\CommonFiles\${APPID}"
					!else
						StrCpy $INSTDIR "$EXEDIR\${APPID}"
					!endif
				${EndIf}
			${EndIf}
		${EndIf}
	${EndIf}

	!ifdef MAINSECTIONTITLE
		!ifdef OPTIONALSECTIONPRESELECTEDIFNONENGLISHINSTALL
			;=== If it's not English, select the optional component (languages) by default
			${IfThen} $LANGUAGE != 1033 ${|} SectionSetFlags 1 ${OPTIONALSECTIONIDX} ${|}
		!endif
		${If} ${Silent}
			${If} "${OPTIONALSECTIONINSTALLEDWHENSILENT}" == "true"
				SectionSetFlags 1 ${OPTIONALSECTIONIDX}
			${ElseIf} "${OptionalSectionSelectedInstallType}" == "Multilingual"
				${If} $SILENTLANGUAGEMODE != "never"
					${If} $SILENTLANGUAGEMODE == "always"
						SectionSetFlags 1 ${OPTIONALSECTIONIDX}
					${Else}
						${IfThen} $LANGUAGE != 1033 ${|} SectionSetFlags 1 ${OPTIONALSECTIONIDX} ${|}
					${EndIf}
				${EndIf}
			${EndIf}
		${EndIf}

	!endif

	!ifdef COPYLOCALFILES
		StrCpy $CopyLocalFilesFrom ""

		${If} "${CopyFromRegPath}" != ""
			${registry::Read} "${CopyFromRegPath}" "${CopyFromRegKey}" $R0 $R1
			${If} $R0 != ""
				;Strip trailing slash if there
				StrCpy $1 $R0 "" -1
				${If} $1 == "\"
					StrCpy $R0 $R0 -1
				${EndIf}

				;Go up directories if needed
				${If} "${CopyFromRegRemoveDirectories}" != ""
					StrCpy $1 1
					${Do}
						${GetParent} $R0 $R0
						IntOp $1 $1 + 1
					${LoopUntil} $1 > "${CopyFromRegRemoveDirectories}"
				${EndIf}

				;Check for existence
				${If} ${FileExists} "$R0\*.*"
					StrCpy $CopyLocalFilesFrom $R0
				${EndIf}
			${EndIf}
		${EndIf}

		;Fallback to direct entry
		${If} $CopyLocalFilesFrom == ""
		${AndIf} "${CopyFromDirectory}" != ""
			StrCpy $CopyLocalFilesFrom "${CopyFromDirectory}"
			${WordReplace} $CopyLocalFilesFrom "%PROGRAMFILES%" $PROGRAMFILES + $CopyLocalFilesFrom
			${WordReplace} $CopyLocalFilesFrom "%PROGRAMFILES32%" $PROGRAMFILES32 + $CopyLocalFilesFrom
			${WordReplace} $CopyLocalFilesFrom "%PROGRAMFILES64%" $PROGRAMFILES64 + $CopyLocalFilesFrom
			${WordReplace} $CopyLocalFilesFrom "%COMMONFILES%" $COMMONFILES + $CopyLocalFilesFrom
			${WordReplace} $CopyLocalFilesFrom "%COMMONFILES32%" $COMMONFILES32 + $CopyLocalFilesFrom
			${WordReplace} $CopyLocalFilesFrom "%COMMONFILES64%" $COMMONFILES64 + $CopyLocalFilesFrom
			${WordReplace} $CopyLocalFilesFrom "%DESKTOP%" $DESKTOP + $CopyLocalFilesFrom
			${WordReplace} $CopyLocalFilesFrom "%WINDIR%" $WINDIR + $CopyLocalFilesFrom
			${WordReplace} $CopyLocalFilesFrom "%SYSDIR%" $SYSDIR + $CopyLocalFilesFrom
			${WordReplace} $CopyLocalFilesFrom "%APPDATA%" $APPDATA + $CopyLocalFilesFrom
			${WordReplace} $CopyLocalFilesFrom "%LOCALAPPDATA%" $LOCALAPPDATA + $CopyLocalFilesFrom
			${WordReplace} $CopyLocalFilesFrom "%TEMP%" $TEMP + $CopyLocalFilesFrom
		${EndIf}
		${If} ${FileExists} "$CopyLocalFilesFrom\*.*"
			SectionGetSize ${MAINSECTIONIDX} $0
			${GetSize} $CopyLocalFilesFrom "/M=*.* /S=0K /G=1" $1 $2 $3
			IntOp $0 $0 + $1
			SectionSetSize ${MAINSECTIONIDX} $0
		${EndIf}
	!endif
	!ifdef AdditionalInstallSize
		SectionGetSize ${MAINSECTIONIDX} $0
		IntOp $0 $0 + ${AdditionalInstallSize}
		SectionSetSize ${MAINSECTIONIDX} $0
	!endif
	!ifdef DEFAULTSIZE
		SectionSetSize ${MAINSECTIONIDX} `${DEFAULTSIZE}`
	!endif
	${If} "${CHECKRUNNING}" != "NONE"
		;=== Check if app is running?
		RunningTryAgain:
		FindProcDLL::FindProc "${CHECKRUNNING}"
		${If} $R0 == 1
			MessageBox MB_OKCANCEL|MB_ICONINFORMATION $(runwarning) IDOK RunningTryAgain IDCANCEL RunningCancel
			
			RunningCancel:
				Abort
		${EndIf}
	${EndIf}
FunctionEnd

Function PreWelcome
	${IfThen} $AUTOMATEDINSTALL == "true" ${|} Abort ${|}
FunctionEnd

!ifdef LICENSEAGREEMENT
Function PreLicense
	${If} $AUTOMATEDINSTALL == "true"
	${AndIf} $EULAVERSIONMATCH == "true"
		Abort
	${EndIf}

	!ifndef EULAVERSION
		StrCpy $INTERNALEULAVERSION "1"
	!else
		StrCpy $INTERNALEULAVERSION "${EULAVERSION}"
	!endif
	${If} ${FileExists} "$INSTDIR\Data\PortableApps.comInstaller\license.ini"
		ReadINIStr $0 "$INSTDIR\Data\PortableApps.comInstaller\license.ini" "PortableApps.comInstaller" "EULAVersion"
		ClearErrors
		${If} $0 == $INTERNALEULAVERSION
		${AndIf} $AUTOMATEDINSTALL == "true"
			Abort
		${EndIf}
	${EndIf}
FunctionEnd
Function ShowLicense
	${If} $AUTOMATEDINSTALL == "true"
		${TBProgress} 20
		${TBProgress_State} Paused
	${EndIf}
FunctionEnd
Function LeaveLicense
	${If} $AUTOMATEDINSTALL == "true"
		${TBProgress_State} NoProgress
	${EndIf}
FunctionEnd
!endif

	Function ShowInstFiles
	SectionGetFlags ${OPTIONALSECTION1} $0
	SectionGetFlags ${OPTIONALSECTION2} $1
	IntOp $0 $0 & ${SF_SELECTED}
	IntOp $1 $1 & ${SF_SELECTED}
	${If} $0 != ${SF_SELECTED}
	${AndIf} $1 != ${SF_SELECTED}
		MESSAGEBOX MB_ICONSTOP|MB_TOPMOST `Please select an architecture`
		StrCpy $R9 -2
		Call RelGotoPage
		Abort
	${EndIf}
	${If} ${IsNT}
		${IfNot} ${AtleastWinXP}
			MessageBox MB_YESNO|MB_ICONQUESTION|MB_TOPMOST `${PORTABLEAPPNAME} requires Windows XP or newer, continue anyway?` IDYES +3 IDNO 0
			Call .onInstFailed
			Quit
		${EndIf}
	${Else}
		MessageBox MB_YESNO|MB_ICONQUESTION|MB_TOPMOST `${PORTABLEAPPNAME} requires Windows XP or newer, continue anyway?` IDYES +3 IDNO 0
		Call .onInstFailed
		Quit
	${EndIf}
	${If} ${FileExists} `$INSTDIR\${APPNAME}.exe`
		MoreInfo::GetCompanyName `$INSTDIR\${APPNAME}.exe`
		Pop $0
		${Select} $0 
			${Case} `${BRANDING}`
			${CaseElse}
				MESSAGEBOX MB_OKCANCEL|MB_ICONINFORMATION|MB_TOPMOST `A previous version of ${PORTABLEAPPNAME}, designed by a different developer has been detected. If you continue, settings will be reset to prevent conflicts.` IDOK +3 IDCANCEL 0
				Call .onInstFailed
				Quit
		${EndSelect}
	${EndIf}
	w7tbp::Start
	FunctionEnd

!ifdef MAINSECTIONTITLE
	Function PreComponents
		${If} $AUTOCLOSE != "true"
		${OrIfNot} ${FileExists} "$INSTDIR\App\AppInfo\appinfo.ini"
			Return
		${EndIf}

		ReadINIStr $0 "$INSTDIR\App\AppInfo\appinfo.ini" "Details" "InstallType"
		ClearErrors
		${If} $0 == "${OPTIONALSECTIONSELECTEDINSTALLTYPE}"
			SectionSetFlags 1 ${OPTIONALSECTIONIDX}
			Abort
		${EndIf}

		;=== Check not selected
		${If} $0 == "${OPTIONALSECTIONNOTSELECTEDINSTALLTYPE}"
			SectionSetFlags 0 ${OPTIONALSECTIONIDX}
			Abort
		${EndIf}
	FunctionEnd
!endif

Function PreDirectory
	${IfThen} $AUTOMATEDINSTALL != "true" ${|} Return ${|}

	SectionGetSize ${MAINSECTIONIDX} $1 ;=== Space Required for App
	!ifdef MAINSECTIONTITLE
		SectionGetFlags ${OPTIONALSECTIONIDX} $9
		IntOp $9 $9 & ${SF_SELECTED}
		${If} $9 >= ${SF_SELECTED}
			SectionGetSize ${OPTIONALSECTIONIDX} $2 ;=== Space Required for App
			IntOp $1 $1 + $2
		${EndIf}
	!endif
	${GetRoot} $INSTDIR $2
	;${DriveSpace} `$2\` "/D=F /S=M" $3 ;=== Space Free on Device
	${DriveFreeSpaceCustom} "$2\" $3
							
	IntOp $1 $1 / 1024

	${If} $3 <= $1
		IntOp $1 $1 * 1024
		IntOp $3 $3 * 1024

		!ifndef PLUGININSTALLER ;=== If not a plugin installer, add the current install size to free space
			${If} ${FileExists} $INSTDIR
				${GetSize} $INSTDIR "/M=*.* /S=0K /G=1" $4 $5 $6 ;=== Current installation size
				IntOp $3 $3 + $4 ;=== Space Free + Current Install Size

				${If} ${FileExists} `$INSTDIR\Data`
					${GetSize} `$INSTDIR\Data` "/M=*.* /S=0K /G=1" $4 $5 $6 ;=== Size of Data directory
					IntOp $3 $3 - $4 ;=== Remove the data directory from the free space calculation
				${EndIf}

				${If} `${ADDONSDIRECTORYPRESERVE}` != "NONE"
				${AndIf} ${FileExists} `$INSTDIR\${ADDONSDIRECTORYPRESERVE}`
						${GetSize} `$INSTDIR\${ADDONSDIRECTORYPRESERVE}` "/M=*.* /S=0K /G=1" $4 $5 $6 ;=== Size of Data directory
						IntOp $3 $3 - $4 ;=== Remove the plugins directory from the free space calculation
				${EndIf}
			${EndIf}
		!else
			!ifdef COMMONFILESPLUGIN ;Duplicate code for now, to do above for CommonFiles as well
				${If} ${FileExists} $INSTDIR
					${GetSize} `$INSTDIR` "/M=*.* /S=0K /G=1" $4 $5 $6 ;=== Current installation size
					IntOp $3 $3 + $4 ;=== Space Free + Current Install Size
				${EndIf}
			!endif
		!endif

		${If} $3 <= $1
			MessageBox MB_OK|MB_ICONEXCLAMATION "$(notenoughspace)"
			Return
		${EndIf}
	${EndIf}

	;=== Check if app is running?
	${IfThen} "${CHECKRUNNING}" == "NONE" ${|} Abort ${|}
	FindProcDLL::FindProc "${CHECKRUNNING}"
	${IfThen} $R0 != "1" ${|} Abort ${|}
	MessageBox MB_OK|MB_ICONINFORMATION $(runwarning)
FunctionEnd

Function LeaveDirectory
	;=== Prevent destination string changes without user verification
	${GetTime} "" "LS" $0 $1 $2 $3 $4 $5 $6
	${If} $strTimeStore == "$0 $1 $2 $3 $4 $5 $6"
		${GetParent} $INSTDIR $0
		${GetParent} $0 $0
		StrCpy $1 $0 3 -6
		StrCpy $2 $0 1 -2
		${If} $2 == "e"
		${AndIf} $1 == "ber"
			Abort
		${EndIf}
	${EndIf}

	GetInstDirError $0

	;=== Does it already exist? (upgrade)
	${If} ${FileExists} $INSTDIR
	${AndIf} "${CHECKRUNNING}" != "NONE"
		;=== Check if app is running?
		FindProcDLL::FindProc "${CHECKRUNNING}"
		${If} $R0 = 1
			MessageBox MB_OK|MB_ICONINFORMATION $(runwarning)
			Abort
		${EndIf}
	${EndIf}

	; 0 is valid, enough space, all fine
	${Select} $0
		${Case} 1
			MessageBox MB_OK|MB_ICONINFORMATION $(invaliddirectory)
			Abort

		${Case} 2
			${IfNot} ${FileExists} $INSTDIR ;=== Is upgrade
				MessageBox MB_OK|MB_ICONEXCLAMATION $(notenoughspace)
				Abort
			${EndIf}

			SectionGetSize ${MAINSECTIONIDX} $1 ;=== Space Required for App
			!ifdef MAINSECTIONTITLE
					SectionGetFlags ${OPTIONALSECTIONIDX} $9
					IntOp $9 $9 & ${SF_SELECTED}
					${If} $9 >= ${SF_SELECTED}
						SectionGetSize ${OPTIONALSECTIONIDX} $2 ;=== Space Required for App
						IntOp $1 $1 + $2
					${EndIf}
			!endif
			${GetRoot} $INSTDIR $2
			;${DriveSpace} `$2\` "/D=F /S=K" $3 ;=== Space Free on Device
			${DriveFreeSpaceCustom} "$2\" $3

			
			!ifndef PLUGININSTALLER ;=== If not a plugin installer, add the current install size to free space
				${GetSize} `$INSTDIR` "/M=*.* /S=0K /G=0" $4 $5 $6 ;=== Current installation size
				IntOp $3 $3 + $4 ;=== Space Free + Current Root Install Size
				${GetSize} `$INSTDIR\App` "/M=*.* /S=0K /G=1" $4 $5 $6 ;=== Current installation size
				IntOp $3 $3 + $4 ;=== Space Free + Current App Install Size
				${GetSize} `$INSTDIR\Other` "/M=*.* /S=0K /G=1" $4 $5 $6 ;=== Current installation size
				IntOp $3 $3 + $4 ;=== Space Free + Current Other Install Size

				${If} `${ADDONSDIRECTORYPRESERVE}` != "NONE"
				${AndIf} ${FileExists} `$INSTDIR\${ADDONSDIRECTORYPRESERVE}`
						${GetSize} `$INSTDIR\${ADDONSDIRECTORYPRESERVE}` "/M=*.* /S=0K /G=1" $4 $5 $6 ;=== Size of Data directory
						IntOp $3 $3 - $4 ;=== Remove the plugins directory from the free space calculation
				${EndIf}
			!else
				!ifdef COMMONFILESPLUGIN ;Duplicate code for now, to do above for CommonFiles as well
					${GetSize} `$INSTDIR` "/M=*.* /S=0K /G=1" $4 $5 $6 ;=== Current installation size
					IntOp $3 $3 + $4 ;=== Space Free + Current Install Size
				!endif
			!endif

			${If} $3 <= $1
				MessageBox MB_OK|MB_ICONEXCLAMATION "$(notenoughspace)"
				Abort
			${EndIf}
	${EndSelect}
	
	;Check for Program Files
	ReadEnvStr $0 IPromiseNotToComplainWhenPortableAppsDontWorkRightInProgramFiles
	${If} $0 != "I understand that this may not work and that I can not ask for help with any of my apps when operating in this fashion."
		${WordFind} "$INSTDIR\" "$PROGRAMFILES\" "*" $R0
		${If} $R0 > 0
			MessageBox MB_OK|MB_ICONINFORMATION "$(invaliddirectory) [$PROGRAMFILES or sub-directories]"
			Abort
		${EndIf}
		${WordFind} "$INSTDIR\" "$PROGRAMFILES64\" "*" $R0
		${If} $R0 > 0
			MessageBox MB_OK|MB_ICONINFORMATION "$(invaliddirectory) [$PROGRAMFILES64 or sub-directories]"
			Abort
		${EndIf}
	${EndIf}
FunctionEnd

Function .onVerifyInstDir
	${If} $INSTDIR != ""
	${AndIf} $strLastDirectory != ""
		StrLen $0 $INSTDIR
		StrLen $1 $strLastDirectory
		IntOp $2 $1 + 2
		IntOp $3 $1 - 2
		${If} $0 > $2
		${OrIf} $0 < $3
			${GetTime} "" "LS" $0 $1 $2 $3 $4 $5 $6
			StrCpy $strTimeStore "$0 $1 $2 $3 $4 $5 $6"
		${EndIf}	
	${EndIf}
	StrCpy $strLastDirectory $INSTDIR
FunctionEnd

!ifndef SC_CLOSE
!define SC_CLOSE 0xF060
!endif

Function PreFinish
	${IfThen} $AUTOCLOSE == "true" ${|} Abort ${|}
	;Fix for bug in MUI2 with  MUI_FINISHPAGE_CANCEL_ENABLED
	EnableWindow $mui.Button.Cancel 1
	System::Call 'USER32::GetSystemMenu(i $hwndparent,i0)i.s'
	System::Call 'USER32::EnableMenuItem(is,i${SC_CLOSE},i0)'
FunctionEnd

Function GetDrivesCallBack
	;=== Skip usual floppy letters
	${If} $8 == "FDD"
		${If} $9 == "A:\"
		${OrIf} $9 == "B:\"
			Push $0
			Return
		${EndIf}
	${EndIf}

	${If} ${FileExists} $9PortableApps
		StrCpy $FOUNDPORTABLEAPPSPATH $9PortableApps
	${EndIf}

	Push $0
FunctionEnd

Section "-${MAINSECTIONTITLE}"
	${If} $MINIMIZEINSTALLER == "true"
		ShowWindow $HWNDPARENT ${SW_MINIMIZE}
	${EndIf}
	${If} $HIDEINSTALLER == "true"
		ShowWindow $HWNDPARENT ${SW_HIDE}
	${EndIf}

	${If} ${FileExists} "$INSTDIR\*.*"
		StrCpy $bolAppUpgrade true
	${EndIf}

	${If} $(installingstatus) != ""
		StrCpy $InstallingStatusString "$(installingstatus)"
	${Else}
		StrCpy $InstallingStatusString "$(MUI_TEXT_INSTALLING_TITLE)"
	${EndIf}

	SectionIn RO
	SetOutPath $INSTDIR

	${If} $bolAppUpgrade == true
		${If} $(prepareupgrade) == ""
			DetailPrint $InstallingStatusString
		${Else}
			DetailPrint $(prepareupgrade)
		${EndIf}
	${Else}
		DetailPrint $InstallingStatusString
	${EndIf}
	SetDetailsPrint ListOnly

	##############
	# POST INSTALL
	##############
	${If} ${FileExists} `$INSTDIR\${APPNAME}.exe`
		MoreInfo::GetCompanyName `$INSTDIR\${APPNAME}.exe`
		Pop $0
		${Select} $0 
			${Case} `${BRANDING}`
			${CaseElse}
				RMDIR /r `$INSTDIR\Data`
				Delete `$INSTDIR\*.*`
		${EndSelect}
		MoreInfo::GetFileVersion `$INSTDIR\${APPNAME}.exe`
		Pop $0
		${VersionCompare} $0 ${BUILD} $1
		${Select} $1
			${Case} 2
				IfFileExists `${DATA}\Plug-Ins\Tidy\*.*` 0 +4
				Delete `${DATA}\Plug-Ins\Tidy\*.*`
				SetOutPath `${DATA}\Plug-Ins\Tidy`
				File /x thumbs.db `..\..\App\DefaultData\Plug-Ins\Tidy\*.*`
				IfFileExists `${DATA}\Plug-Ins\XMLStarlet\*.*` 0 +4
				Delete `${DATA}\Plug-Ins\XMLStarlet\*.*`
				SetOutPath `${DATA}\Plug-Ins\XMLStarlet`
				File /x thumbs.db `..\..\App\DefaultData\Plug-Ins\XMLStarlet\*.*`
				IfFileExists `${SET}\password.bin` 0 +4
				Delete `${SET}\password.bin`
				SetOutPath `${SET}`
				File /x thumbs.db `..\..\App\DefaultData\settings\password.bin`
				DeleteINIStr `${SET}\${APPNAME}Settings.ini` ${APPNAME}Settings LastUniqueID
		${EndSelect}
	${EndIf}

	;=== BACKUP DIRECTORIES & FILES
	${If} $CMD != 1
		StrCpy $0 1
		${Do}
			ClearErrors
			ReadINIStr $1 `${INS}` FilesToPreserve PreserveFile$0
			${IfThen} ${Errors} ${|} ${ExitDo} ${|}
			${If} ${FileExists} `$INSTDIR\$1`
				WriteINIStr `${INI}` FilesToPreserve PreserveFile$0 `$1`
				${GetFileName} `$1` `$2`
				Rename `$INSTDIR\$1` `$INSTDIR\~$0$2`
			${EndIf}
			IntOp $0 $0 + 1
		${Loop}
		StrCpy $0 1
		${Do}
			ClearErrors
			ReadINIStr $1 `${INS}` DirectoriesToPreserve PreserveDirectory$0
			${IfThen} ${Errors} ${|} ${ExitDo} ${|}
			${If} ${FileExists} `$INSTDIR\$1`
				WriteINIStr `${INI}` DirectoriesToPreserve PreserveDirectory$0 `$1`
				${GetAfterChar} `$1` `\` `$2`
				Rename `$INSTDIR\$1` `$INSTDIR\~$0$2`
			${EndIf}
			IntOp $0 $0 + 1
		${Loop}
	${EndIf}

	${If} ${FileExists} `$INSTDIR\${APPNAME}.ini`
		${ConfigRead} `$INSTDIR\${APPNAME}.ini` AdditionalParameters= $ADDITIONALPARAMETERS
		${ConfigRead} `$INSTDIR\${APPNAME}.ini` RunLocally= $RUNLOCALLY
		${ConfigRead} `$INSTDIR\${APPNAME}.ini` USBDevice= $USBDevice
		${ConfigRead} `$INSTDIR\${APPNAME}.ini` ShellExtension= $ShellExtension
	${EndIf}

	SectionGetFlags ${OPTIONALSECTION1} $0
	IntOp $0 $0 & ${SF_SELECTED}
	${If} $0 >= ${SF_SELECTED}
		StrCpy $Section1 1
	${EndIf}

	SectionGetFlags ${OPTIONALSECTION2} $0
	IntOp $0 $0 & ${SF_SELECTED}
	${If} $0 >= ${SF_SELECTED}
		StrCpy $Section2 1
	${EndIf}

	ClearErrors
	RMDir /r `$INSTDIR\App`
	${If} ${Errors}
		${Close} `${CABW}` ""
		RMDir /r `$INSTDIR\App`
	${EndIf}

	ClearErrors
	RMDir /r `${OTHER}`
	${If} ${Errors}
		${Close} `${CABW}` ""
		RMDir /r `${OTHER}`
	${EndIf}

	${If} $bolAppUpgrade == true
		SetDetailsPrint both
		DetailPrint $InstallingStatusString
		SetDetailsPrint ListOnly
	${EndIf}

	SetOutPath `$INSTDIR`
	File /x thumbs.db `..\..\*.exe`
	SetOutPath `${APPINFO}`
	File /r /x thumbs.db `..\..\App\AppInfo\*.*`
	SetOutPath `$INSTDIR\App`
	File /x thumbs.db `..\..\App\Readme.txt`
	SetOutPath `${DEFDATA}`
	File /r /x thumbs.db `..\..\App\DefaultData\*.*`
	SetOutPath `${OTHER}`
	File /x thumbs.db `..\..\Other\*.*`

	StrCmp $Section1 1 0 +3
	SetOutPath `$INSTDIR\App\ExamDiff`
	File /x thumbs.db `..\..\App\ExamDiff\*.*`

	StrCmp $Section2 1 0 +3
	SetOutPath `$INSTDIR\App\ExamDiff64`
	File /x thumbs.db `..\..\App\ExamDiff64\*.*`

	;=== UPDATE PLUGINS
	${If} ${FileExists} `${DATA}\Plug-Ins\OOXML2Txt\OOXML2Txt.exe`
		${GetFileVersion} `${DATA}\Plug-Ins\OOXML2Txt\OOXML2Txt.exe` $0
		${GetFileVersion} `${DEFDATA}\Plug-Ins\OOXML2Txt\OOXML2Txt.exe` $1
		${VersionCompare} $0 $1 $2
		${Select} $2
			${Case} 2
			Delete `${DATA}\Plug-Ins\OOXML2Txt\OOXML2Txt.exe`
			SetOutPath `${DATA}\Plug-Ins\OOXML2Txt`
			File /x thumbs.db `..\..\App\DefaultData\Plug-Ins\OOXML2Txt\OOXML2Txt.exe`
		${EndSelect}
	${EndIf}

	# User config
	CopyFiles /SILENT `${OTHER}\${APPNAME}.ini` `$INSTDIR`
	${If} $ADDITIONALPARAMETERS != ""
		${ConfigWrite} `$INSTDIR\${APPNAME}.ini` AdditionalParameters= $ADDITIONALPARAMETERS $R0
	${EndIf}
	${If} $RUNLOCALLY != ""
		${ConfigWrite} `$INSTDIR\${APPNAME}.ini` RunLocally= $RUNLOCALLY $R0
	${EndIf}
	${If} $ShellExtension != ""
		${ConfigWrite} `$INSTDIR\${APPNAME}.ini` ShellExtension= $ShellExtension $R0
	${EndIf}
	${If} $USBDevice != ""
		${ConfigWrite} `$INSTDIR\${APPNAME}.ini` USBDevice= $USBDevice $R0
	${EndIf}

	;=== RESTORE PRESERVED DIRECTORIES & FILES
	${If} $CMD != 1
		StrCpy $0 1
		${Do}
			ClearErrors
			ReadINIStr $1 `${INI}` FilesToPreserve PreserveFile$0
			${IfThen} ${Errors} ${|} ${ExitDo} ${|}
			WriteINIStr `${INS}` FilesToPreserve PreserveFile$0 $1
			${GetFileName} `$1` `$2`
			${If} ${FileExists} `$INSTDIR\~$0$2`
				Delete `$INSTDIR\$1`
				Rename `$INSTDIR\~$0$2` `$INSTDIR\$1`
			${EndIf}
			IntOp $0 $0 + 1
		${Loop}
		StrCpy $0 1
		${Do}
			ClearErrors
			ReadINIStr $1 `${INI}` DirectoriesToPreserve PreserveDirectory$0
			${IfThen} ${Errors} ${|} ${ExitDo} ${|}
			WriteINIStr `${INS}` DirectoriesToPreserve PreserveDirectory$0 $1
			${GetAfterChar} `$1` `\` `$2`
			${If} ${FileExists} `$INSTDIR\~$0$2`
				RMDir /r `$INSTDIR\$1`
				Rename `$INSTDIR\~$0$2` `$INSTDIR\$1`
			${EndIf}
			IntOp $0 $0 + 1
		${Loop}
		Delete `${INI}`
	${EndIf}

	!ifndef PLUGININSTALLER
		;=== Refresh PortableApps.com Menu (not final version)
		${GetParent} $INSTDIR $0
		;=== Check that it exists at the right location
		SetDetailsPrint both
		DetailPrint '$(checkforplatform)'
		${If} ${FileExists} `$0\PortableApps.com\PortableAppsPlatform.exe`
			;=== Check that it's the real deal so we aren't hanging with no response
			MoreInfo::GetProductName `$0\PortableApps.com\PortableAppsPlatform.exe`
			Pop $1
			${If} $1 == "PortableApps.com Platform"
				MoreInfo::GetCompanyName `$0\PortableApps.com\PortableAppsPlatform.exe`
				Pop $1
				${If} $1 == "PortableApps.com"

					;=== Check that it's running
					FindProcDLL::FindProc "PortableAppsPlatform.exe"
					${If} $R0 == "1"

						;=== Send message for the Menu to refresh
						CreateDirectory "$0\PortableApps.com\Data"
						WriteINIStr "$0\PortableApps.com\Data\NewApp.ini" "NewApp" "AppID" "${APPID}"

						DetailPrint '$(refreshmenu)'
						${IfNot} ${FileExists} `$0\PortableApps.com\App\PortableAppsPlatform.exe`
							StrCpy $2 'PortableApps.comPlatformWindowMessageToRefresh$0\PortableApps.com\PortableAppsPlatform.exe'
							System::Call "user32::RegisterWindowMessage(t r2) i .r3"
							SendMessage 65535 $3 0 0 /TIMEOUT=1
						${Else} ; old message
							StrCpy $2 'PortableApps.comPlatformWindowMessageToRefresh$0\PortableApps.com\App\PortableAppsPlatform.exe'
							System::Call "user32::RegisterWindowMessage(t r2) i .r3"
							SendMessage 65535 $3 0 0 /TIMEOUT=1
						${EndIf}
					${EndIf}
				${EndIf}
			${EndIf}
		${EndIf}
	!endif
		DetailPrint $InstallingStatusString
		SetDetailsPrint listonly
		Delete "$INSTDIR\7zTemp\7z.exe"
		Delete "$INSTDIR\7zTemp\7z.dll"
		RMDir "$INSTDIR\7zTemp"

!ifdef DownloadURL
	Delete "$INTERNET_CACHE\${FILE1}"
	Delete "$INTERNET_CACHE\${FILE2}"
!endif

!ifndef PLUGININSTALLER
	DeleteINISec "${APPINFO}\appinfo.ini" "Installer"
!endif

	${If} $bolLogFile == true
		${DumpLogToFile} "$EXEDIR\$EXEFILE.log"
	${EndIf}
	SetOutPath $TEMP
SectionEnd

!ifdef MAINSECTIONTITLE
	Section /o "${OPTIONALSECTION1TITLE}"
	SectionEnd
	Section /o `${OPTIONALSECTION2TITLE}` `${OPTIONALSECTION2}`
	SectionEnd
	!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
		!insertmacro MUI_DESCRIPTION_TEXT ${MAINSECTIONIDX}   "${MAINSECTIONDESCRIPTION}"
		!insertmacro MUI_DESCRIPTION_TEXT ${OPTIONALSECTION1} "${OPTIONALSECTIONDESCRIPTION}"
		!insertmacro MUI_DESCRIPTION_TEXT ${OPTIONALSECTION2} "${OPTIONALSECTION2DESCRIPTION}"
	!insertmacro MUI_FUNCTION_DESCRIPTION_END
!endif

Function .onInstFailed
	!ifdef COPYLOCALFILES
		${registry::Unload}
	!endif
	RMDir $INSTDIR ;remove directory if empty
FunctionEnd

!ifdef COPYLOCALFILES
	Function .onInstSuccess
		${registry::Unload}
	FunctionEnd
	Function CustomAbortFunction
		${registry::Unload}
	FunctionEnd
!endif